package rest_api;

import javax.ws.rs.*;
import java.util.ArrayList;
import java.util.List;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/")

public class HiveDataService {
                @GET
                @Path("/HiveData/PurchaseDetail")                
                @Produces(MediaType.APPLICATION_JSON)
               
                public  Response  fetchData() {                	
                	List<Message> messages = new ArrayList<>();
                	System.out.println("Getting Data from Hadoop using Hive driver");

                    try {
                        String driverName = "org.apache.hive.jdbc.HiveDriver";
                        Class.forName(driverName);
                    } catch (ClassNotFoundException e) {

                        e.printStackTrace();
                        System.exit(1);
                    }
                    try {
                        Connection con = DriverManager.getConnection("jdbc:hive2://192.168.99.100:10000/", "cloudera", "cloudera");

                        Statement stmt = con.createStatement();
                        String sql = "SELECT * FROM Online_Retail WHERE UnitPrice>1000 AND Country = 'United Kingdom'";
                        System.out.println("Running: " + sql);
                        ResultSet res = stmt.executeQuery(sql);
                        while (res.next()) {
                        	
                        	Message m = new Message();
                            m.setInvoiceNo(res.getString(1));
                            m.setStockCode(res.getString(2));
                            m.setDescription(res.getString(3));
                            m.setQuantity(res.getString(4));
                            m.setInvoiceDate(res.getString(5));
                            m.setUnitPrice(res.getString(6));
                            m.setCustomerId(res.getString(7));
                            m.setCountry(res.getString(8));                       
                            messages.add(m);
                        	
                        }
                        res.close();

                        System.out.println("Query execution complete");
                    } catch (SQLException e) {

                        e.printStackTrace();
                    }

                    return Response
                    	      .status(Response.Status.OK)
                    	      .entity(messages)
                    	      .build();
                   
                }
                
}